// Typewriter effect for the introduction text

const typeSpeed = 20;

function typeWriter(index = 0) {
	const introElement = document.querySelector('#texto-introducao');
	if (!introElement || !window.quizConfig) return;

	// reset content to avoid duplicated typing on reruns
	if (index === 0) introElement.innerHTML = '<span class="quiz-intro__typewriter"></span>';

	const typewriterBar = document.querySelector('.quiz-intro__typewriter');
	const count = Array.isArray(window.quizConfig.questions) ? window.quizConfig.questions.length : 0;
	const introText = `Responda ${count} perguntas rápidas pra saber se o protocolo que eu desenvolvi pode funcionar no seu caso.<br>Prometo que é bem rapidinho!`;

	if (index < introText.length) {
		const char = introText[index];

		if (char === '<') {
			let tag = '';
			while (introText[index] !== '>' && index < introText.length) tag += introText[index++];
			tag += '>';
			typewriterBar.insertAdjacentHTML('beforebegin', tag);
		} else {
			typewriterBar.insertAdjacentText('beforebegin', char);
		}

		setTimeout(() => typeWriter(index + 1), typeSpeed);
	} else if (typewriterBar) {
		typewriterBar.style.display = 'none';
	}
}
