// Quiz dynamic rendering and navigation

const renderQuiz = () => {
    const rightColumn =
        document.querySelector('.quiz-box .row.pt-4.align-items-center > div:last-child') ||
        document.querySelector('.quiz-box');
    if (!rightColumn) return;

    // hide static questions if present
    document.querySelectorAll('.questao').forEach(el => (el.style.display = 'none'));

    let root = document.querySelector('#quiz-root');
    if (!root) {
        root = document.createElement('div');
        root.id = 'quiz-root';
        rightColumn.prepend(root);
    }
    root.innerHTML = '';

    // intro
    const introDiv = document.createElement('div');
    introDiv.className = 'quiz-box__intro-content';
         introDiv.innerHTML = '<div id="texto-introducao" class="quiz-intro"><span class="quiz-intro__typewriter"></span></div>';
    root.appendChild(introDiv);

    // questions
    const questionsWrapper = document.createElement('div');
    questionsWrapper.className = 'quiz-questions-wrapper';

    quizConfig.questions.forEach((q, idx) => {
        const questionIdx = idx + 1;
        const container = document.createElement('div');
        container.className = 'quiz-question';
        container.id = `question-${questionIdx}`;
        if (idx !== 0) container.style.display = 'none';

        const titleHtml = `<div class="quiz-box__question-title-content"><h3 class="quiz-box__question-number"><span style="font-weight: 700; font-size: 18px">Pergunta ${questionIdx}.</span></h3><h3>${q.question}</h3></div>`;
        const optionsHtml = q.answers
            .map(
                a =>
                    `<button 
                        class="quiz-options__item" 
                        data-next="${questionIdx + 1}"
                    >${a}</button>`
            )
            .join('');
        container.innerHTML = `${titleHtml}<div class="quiz-box__options-content"><div class="quiz-options">${optionsHtml}</div></div>`;

        questionsWrapper.appendChild(container);
    });

    root.appendChild(questionsWrapper);

    // final step
    const finalStepIdx = quizConfig.questions.length + 1;
    const finalDiv = document.createElement('div');
    finalDiv.className = 'quiz-final';
    finalDiv.id = `question-${finalStepIdx}`;
    finalDiv.style.display = 'none';
    finalDiv.innerHTML = `
		<div class="quiz-box__question-title-content">
			<div class="quiz-final__text">
				<p>
					Esse é, na verdade, um dos sinais de enfraquecimento da visão.<br><br>
					E também é um dos que costuma suavizar mais rápido com esse protocolo natural.<br><br>
					Por isso, fico feliz em te dizer que você atende a todos os requisitos para assistir essa apresentação exclusiva.<br><br>
					Mas só posso te enviar se você se comprometer a assistir até o final.
				</p>
			</div>
		</div>
		<div class="quiz-box__options-content">
			<div class="quiz-options">
                <a class="quiz-options__item quiz-options__item--green" href="${quizConfig.links.assistir}">Sim, vou assistir tudo! Estou comprometida a MELHORAR minha visão.</a>
 
				<a class="quiz-options__item quiz-options__item--gray" href="${quizConfig.links.naoAssistir}">Não, obrigada.<br>Vou continuar com minha visão do jeito que está.</a>
			</div>
		</div>
	`;

    root.appendChild(finalDiv);
};

const setupQuizNavigation = () => {
    let currentQuestion = 1;
    const totalSteps = quizConfig.questions.length + 1;

         document.querySelectorAll('.quiz-options__item').forEach(option => {
         option.addEventListener('click', function () {
             const nextQuestion = parseInt(this.getAttribute('data-next'));
             if (!nextQuestion) return;
 
             // Hide intro content after first question
             if (currentQuestion === 1) {
                 const introContent = document.querySelector('.quiz-box__intro-content');
                 if (introContent) introContent.style.display = 'none';
             }
 
             const currentEl = document.querySelector(`#question-${currentQuestion}`);
             const nextEl = document.querySelector(`#question-${nextQuestion}`);
 
             if (currentEl && nextEl) {
                 currentEl.style.display = 'none';
                 nextEl.style.display = 'block';
                 currentQuestion = nextQuestion;
                 updateProgressBar(currentQuestion, totalSteps);
             }
         });
     });
};

const updateProgressBar = (step, totalSteps) => {
    const newWidth = (step / totalSteps) * 99.3;
    const bar = document.querySelector('.quiz-progress__bar');
    if (bar) bar.style.width = `${newWidth}%`;
};

document.addEventListener('DOMContentLoaded', () => {
    renderQuiz();
    setupQuizNavigation();
    if (window.typeWriter) typeWriter();
    updateProgressBar(1, quizConfig.questions.length + 1);
});
